import fs from "node:fs";
import util from "node:util";
import path from "node:path";
// @ts-expect-error invalid type?
import { isBinary, isText } from "istextorbinary";
const readFile = util.promisify(fs.readFile);
const detectContentType = (filePath, content) => {
    if (isBinary(filePath, content)) {
        return "binary";
    }
    else if (isText(filePath, content)) {
        return "text";
    }
    else {
        return "unknown";
    }
};
export const createRawSource = (filePath) => {
    return readFile(filePath).then((content) => {
        const contentType = detectContentType(filePath, content);
        return {
            filePath,
            content: content.toString(),
            ext: path.extname(filePath),
            contentType,
        };
    });
};
//# sourceMappingURL=index.js.map